/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.effects;

import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;

import intrinsic.flash.filters.*;

public class DropShadowEffect extends Effect {
	
	public DropShadowEffect() {
		super();
	}
	
	void createHandle() {
		DropShadowFilter filter = new DropShadowFilter();
		if (filter == null) SWT.error(SWT.ERROR_NO_HANDLES);
		object = filter;
	}
	
	public void setAngle(double angle) {
		checkEffect();
		((DropShadowFilter)object).angle = angle;
	}

	public void setAlpha(double alpha) {
		checkEffect();
		((DropShadowFilter)object).alpha = alpha;
	}
	
	public void setColor(Color color) {
		checkEffect();
		((DropShadowFilter)object).color = color.handle;
	}
	
	public void setDistance(double distance) {
		checkEffect();
		((DropShadowFilter)object).distance = distance;
	}
	
	public void setSoftness(double softness) {
		checkEffect();
		((DropShadowFilter)object).strength = (1 - softness) * 255;
	}
}
